import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {ESubscriptionPromoCodeType} from 'types/subscription/ESubscriptionPromoCodeType';

import {IDevice} from 'reducers/common/commonReducerTypes';

import Button from 'components/Button/Button';

import DeviceTypeContext from 'contexts/DeviceTypeContext';
import LayersContext from 'contexts/LayersContext';

import SubscriptionPopup from './SubscriptionPopup';

export default {
    title: 'Example/SubscriptionPopup',
    component: SubscriptionPopup,
} as Meta;

const deviceTypeDefault: IDevice = {
    isTouch: false,
    isIe: false,
    os: {name: '', version: ''},
    browser: {name: '', version: ''},
    isMobile: false,
    isDesktop: false,
};

export const DesktopFix: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);

    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isDesktop: true}}
        >
            <LayersContext.Provider value={20}>
                <Button onClick={(): void => setVisibility(true)}>
                    Хочу подписаться
                </Button>

                <SubscriptionPopup
                    isVisible={isVisible}
                    onClose={(): void => setVisibility(false)}
                    onSubmit={() => {}}
                    promoCode={{
                        type: ESubscriptionPromoCodeType.FIX,
                        amount: 500,
                        minTotalCost: 3000,
                    }}
                />
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};

export const DesktopPercent: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);

    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isDesktop: true}}
        >
            <LayersContext.Provider value={20}>
                <Button onClick={(): void => setVisibility(true)}>
                    Хочу подписаться
                </Button>

                <SubscriptionPopup
                    isVisible={isVisible}
                    onClose={(): void => setVisibility(false)}
                    onSubmit={() => {}}
                    promoCode={{
                        type: ESubscriptionPromoCodeType.PERCENT,
                        amount: 10,
                    }}
                />
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};

export const MobileFix: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);

    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isMobile: true}}
        >
            <LayersContext.Provider value={20}>
                <Button onClick={(): void => setVisibility(true)}>
                    Хочу подписаться
                </Button>

                <SubscriptionPopup
                    isVisible={isVisible}
                    onClose={(): void => setVisibility(false)}
                    onSubmit={() => {}}
                    promoCode={{
                        type: ESubscriptionPromoCodeType.FIX,
                        amount: 3000,
                    }}
                />
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};

export const MobilePercent: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);

    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isMobile: true}}
        >
            <LayersContext.Provider value={20}>
                <Button onClick={(): void => setVisibility(true)}>
                    Хочу подписаться
                </Button>

                <SubscriptionPopup
                    isVisible={isVisible}
                    onClose={(): void => setVisibility(false)}
                    onSubmit={() => {}}
                    promoCode={{
                        type: ESubscriptionPromoCodeType.PERCENT,
                        amount: 50,
                        minTotalCost: 500,
                    }}
                />
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};
