import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import SubscriptionContent, {
    ISubscriptionContentProps,
} from 'components/SubscriptionContent/SubscriptionContent';
import ModalOrBottomSheet from 'components/ModalOrBottomSheet/ModalOrBottomSheet';

import cx from './SubscriptionPopup.scss';

interface ISubscriptionPopupProps
    extends Omit<
        ISubscriptionContentProps,
        'pictureSize' | 'pictureClassName'
    > {
    isVisible: boolean;
    onClose(): void;
}

/**
 * TODO: В задаче https://st.yandex-team.ru/TRAVELFRONT-6275 должны вернуть использование этого компонента
 * Если до конца ноября 2021 не вернем, то нужно компонент удалить
 */
const SubscriptionPopup: React.FC<ISubscriptionPopupProps> = props => {
    const {className, promoCode, isVisible, onClose, ...rest} = props;
    const deviceType = useDeviceType();

    return (
        <ModalOrBottomSheet isVisible={isVisible} onClose={onClose}>
            <SubscriptionContent
                className={cx(deviceMods('content', deviceType))}
                pictureSize={deviceType.isDesktop ? 'm' : 's'}
                pictureClassName={cx(
                    'picture',
                    deviceMods('picture', deviceType),
                )}
                promoCode={promoCode}
                {...rest}
            />
        </ModalOrBottomSheet>
    );
};

export default SubscriptionPopup;
