import EPopupDirection from 'components/Popup/types/EPopupDirection';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {TDropdownSuggestDirection} from 'components/Suggest/components/DropdownSuggest/DropdownSuggest';

type TMapDirections = Record<TDropdownSuggestDirection, EPopupDirection[]>;

const mapDirectionsForMobile: TMapDirections = {
    top: [EPopupDirection.TOP],
    bottom: [EPopupDirection.BOTTOM],
};

const mapDirectionsForDesktop: TMapDirections = {
    top: [EPopupDirection.TOP_LEFT],
    bottom: [EPopupDirection.BOTTOM_LEFT],
};

export default function convertSuggestDirection(
    dropdownDirection: TDropdownSuggestDirection,
    deviceType: IDevice,
): EPopupDirection[] | undefined {
    if (deviceType.isMobile) {
        return mapDirectionsForMobile[dropdownDirection];
    }

    return mapDirectionsForDesktop[dropdownDirection];
}
