import React from 'react';

import {IBaseOption} from 'components/Suggest/types/BaseOption';

import Text from 'components/Text/Text';

import cx from './DefaultSuggestOption.scss';

interface IDefaultSuggestOptionProps {
    option: IBaseOption;
}

export const DefaultSuggestOption: React.FC<IDefaultSuggestOptionProps> = ({
    option,
}) => {
    return (
        <div className={cx('option')}>
            <Text
                size="m"
                className={cx('title')}
                tagProps={{title: option.title}}
            >
                {option.title}
            </Text>
            {option.comment && (
                <Text
                    className={cx('comment')}
                    size="s"
                    color="secondary"
                    tagProps={{title: option.comment}}
                >
                    {option.comment}
                </Text>
            )}
        </div>
    );
};
