import React, {useCallback} from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import cx from './SuggestItem.scss';

export interface ISuggestItemProps {
    id: number;
    isActive?: boolean;

    onClick?: (index: number) => void;
    onMouseEnter?: (index: number) => void;
    onMouseLeave?: () => void;
}

const SuggestItem: React.FC<ISuggestItemProps> = ({
    children,
    id,
    isActive,
    onClick,
    onMouseEnter,
    onMouseLeave,
}) => {
    const deviceType = useDeviceType();
    const handleClick = useCallback(() => onClick?.(id), [onClick, id]);

    const handleMouseEnter = useCallback(
        () => onMouseEnter?.(id),
        [onMouseEnter, id],
    );

    return (
        <button
            className={cx('root', deviceMods('root', deviceType), {
                root_active: isActive,
            })}
            type="button"
            tabIndex={-1}
            onMouseDown={handleClick}
            onMouseEnter={handleMouseEnter}
            onMouseLeave={onMouseLeave}
        >
            {children}
        </button>
    );
};

export default SuggestItem;
