import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {useSupportPhone} from 'hooks/useSupportPhone';

import Phone from 'components/Phone/Phone';

interface ISupportPhoneProps extends IWithClassName, IWithQaAttributes {
    justText?: boolean;
    phone?: string;
}

const SupportPhone: React.FC<ISupportPhoneProps> = props => {
    const {className, justText, phone} = props;
    const supportPhone = useSupportPhone();

    if (justText) return <span>{supportPhone}</span>;

    return (
        <Phone
            className={className}
            phone={phone || supportPhone}
            {...prepareQaAttributes('support-phone')}
            {...prepareQaAttributes(props)}
        />
    );
};

export default React.memo(SupportPhone);
