import {ReactNode} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Swipeable, {ISwipeableRenderItemParams} from './Swipeable';

export default {
    title: 'Example/Swipeable',
    component: Swipeable,
} as Meta;

const renderer = ({
    data: label,
}: ISwipeableRenderItemParams<string>): ReactNode => (
    <span style={{fontSize: '200px'}}>{label}</span>
);

export const Simple: TStorybookFunctionComponent = () => (
    <Swipeable
        renderItem={renderer}
        itemsData={['A', 'B', 'C', 'D', 'E']}
        withSwipeDown
        style={{
            border: '1px solid red',
            overflow: 'hidden',
            width: '200px',
            height: '200px',
        }}
    />
);

export const Threshold: TStorybookFunctionComponent = () => (
    <Swipeable
        sideThreshold={0.1}
        renderItem={renderer}
        itemsData={['A', 'B', 'C', 'D', 'E']}
        style={{
            border: '1px solid red',
            overflow: 'hidden',
            width: '200px',
            height: '200px',
        }}
    />
);
