import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import ArrowLongRightIcon from 'icons/16/ArrowLongRight';
import ArrowShortRightIcon from 'icons/16/ArrowShortRight';

import Tab from '../Tab/Tab';

import cx from './TabArrow.scss';

interface IBreadcrumbsArrowProps {
    disabled?: boolean;
}

const TabArrow: React.FC<IBreadcrumbsArrowProps> = props => {
    const {disabled} = props;
    const deviceType = useDeviceType();

    const Icon = deviceType.isMobile ? ArrowShortRightIcon : ArrowLongRightIcon;

    return (
        <Tab active={false} bold={false} innerRef={undefined}>
            <Icon className={cx('arrow', {arrow_disabled: disabled})} />
        </Tab>
    );
};

export default React.memo(TabArrow);
