import React, {useCallback} from 'react';

import {IRenderTabProps} from 'components/Tabs/types/IRenderTabProps';

interface IGetPropsForRenderTabParams<TabType, TabIdType> {
    checkActiveTab(tab: TabType, tabId: TabIdType): boolean;
    handleTabClick(tab: TabType, tabId: TabIdType): void;
    activeTabRef: React.RefObject<HTMLButtonElement>;
    bold: boolean;
}

interface IRenderTabFunction<TabType, TabIdType> {
    (tab: TabType, tabId: TabIdType, tabDisabled: boolean): IRenderTabProps<
        TabType,
        TabIdType
    >;
}

export default function useGetPropsForRenderTab<TabType, TabIdType>({
    checkActiveTab,
    handleTabClick,
    activeTabRef,
    bold,
}: IGetPropsForRenderTabParams<TabType, TabIdType>): IRenderTabFunction<
    TabType,
    TabIdType
> {
    return useCallback(
        (
            tab: TabType,
            tabId: TabIdType,
            tabDisabled: boolean,
        ): IRenderTabProps<TabType, TabIdType> => {
            const active = checkActiveTab(tab, tabId);

            return {
                key: tabId,
                tab,
                tabProps: {
                    active,
                    bold,
                    disabled: tabDisabled,
                    innerRef: active ? activeTabRef : undefined,
                    onClick: (): void => {
                        handleTabClick(tab, tabId);
                    },
                },
            };
        },
        [activeTabRef, bold, checkActiveTab, handleTabClick],
    );
}
