import React from 'react';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18nNew/hotels-SearchPage';

import Text from 'components/Text/Text';
import Link from 'components/Link/Link';
import Box from 'components/Box/Box';

const TaxiDisclaimer: React.FC = () => (
    <Text size="s" color="secondary">
        {insertJSXIntoKey(i18nBlock.taxiPromocodePage)({
            link: (
                <Link
                    url={i18nBlock.taxiPromocodePageLinkUrl()}
                    target="_blank"
                    rel="nofollow noopener noreferrer"
                >
                    {i18nBlock.taxiPromocodePageLinkText()}
                </Link>
            ),
        })}

        <Box above={2}>{i18nBlock.taxiPromocodeDisclaimer()}</Box>
    </Text>
);

export default TaxiDisclaimer;
