import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';
import Box from 'components/Box/Box';

import TextArea from './TextArea';

export default {
    title: 'Example/TextArea',
    component: TextArea,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 'm',
                size: 'm',
                example: (
                    <Box between={4}>
                        <TextArea size="m" />
                        <TextArea size="m" disabled />
                        <TextArea size="m" placeholder="Плейсхолдер есть" />
                        <TextArea
                            size="m"
                            value="Есть крестик для очистки"
                            hasClear
                        />
                        <TextArea
                            size="m"
                            hint="Может показывать ошибки"
                            state="error"
                        />
                        <TextArea
                            size="m"
                            rows={4}
                            value="Если текста много, то появляется скроллбар. Это очень удобно. Если текста много, то появляется скроллбар. Это очень удобно. Если текста много, то появляется скроллбар. Это очень удобно.  Если текста много, то появляется скроллбар. Это очень удобно. Если текста много, то появляется скроллбар. Это очень удобно. Если текста много, то появляется скроллбар. Это очень удобно. Если текста много, то появляется скроллбар. Это очень удобно. Если текста много, то появляется скроллбар. Это очень удобно.  Если текста много, то появляется скроллбар. Это очень удобно. Если текста много, то появляется скроллбар. Это очень удобно."
                        />
                        <TextArea
                            size="m"
                            withAutoResize={true}
                            value="А еще контрол умеет подстраиваться под высоту контента, это тоже иногда бывает нужно. А еще контрол умеет подстраиваться под высоту контента, это тоже иногда бывает нужно. А еще контрол умеет подстраиваться под высоту контента, это тоже иногда бывает нужно. А еще контрол умеет подстраиваться под высоту контента, это тоже иногда бывает нужно. А еще контрол умеет подстраиваться под высоту контента, это тоже иногда бывает нужно. А еще контрол умеет подстраиваться под высоту контента, это тоже иногда бывает нужно. А еще контрол умеет подстраиваться под высоту контента, это тоже иногда бывает нужно. А еще контрол умеет подстраиваться под высоту контента, это тоже иногда бывает нужно."
                        />
                    </Box>
                ),
            },
            {
                name: 's',
                size: 's',
                example: (
                    <Box between={4}>
                        <TextArea size="s" />
                        <TextArea size="s" disabled />
                    </Box>
                ),
            },
        ]}
    />
);
