import React from 'react';

import {
    TextAreaPresenter,
    TextAreaPresenterWithAutoResize,
} from 'components/TextArea/controls/TextAreaPresenter';
import {ITextareaProps as ILegoTextAreaProps} from '@yandex-lego/components/Textarea/desktop';

interface ITextAreaProps extends ILegoTextAreaProps {
    value?: string;
    size?: 's' | 'm';
    hasClear?: boolean;
    withAutoResize?: boolean;
}

const TextArea: React.FC<ITextAreaProps> = ({
    size = 'm',
    withAutoResize,
    ...rest
}) => {
    const Presenter = withAutoResize
        ? TextAreaPresenterWithAutoResize
        : TextAreaPresenter;

    return <Presenter {...rest} size={size} view="default" />;
};

export default TextArea;
