import React from 'react';
import {compose, composeU} from '@bem-react/core';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {
    withSizeS,
    withSizeM,
    withHasClear,
    withAutoResize,
    withViewDefault,
    Textarea as LegoTextArea,
    ITextareaProps as ILegoTextAreaProps,
} from '@yandex-lego/components/Textarea/desktop';
import {cnTextArea} from 'components/TextArea/cnTextArea';

const YTLegoTextAreaWrapper: React.FC<ILegoTextAreaProps & IWithQaAttributes> =
    props => (
        <LegoTextArea
            className={cnTextArea(null, [props.className])}
            {...props}
            {...prepareQaAttributes(props)}
        />
    );

export const TextAreaPresenter = compose(
    composeU(withSizeS, withSizeM),
    withViewDefault,
    withHasClear,
)(YTLegoTextAreaWrapper);

export const TextAreaPresenterWithAutoResize = compose(
    composeU(withSizeS, withSizeM),
    withViewDefault,
    withHasClear,
    withAutoResize,
)(YTLegoTextAreaWrapper);
