import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {ETimeOfDay} from 'utilities/dateUtils/types';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import TimeFilter from './TimeFilter';

export default {
    title: 'Example/TimeFilter',
    component: TimeFilter,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [values, setValues] = useState<ETimeOfDay[]>([]);
    const deviceType = useDeviceType();

    return (
        <TimeFilter
            value={values}
            availableValues={[
                ETimeOfDay.MORNING,
                ETimeOfDay.DAY,
                ETimeOfDay.NIGHT,
            ]}
            options={[
                ETimeOfDay.MORNING,
                ETimeOfDay.DAY,
                ETimeOfDay.EVENING,
                ETimeOfDay.NIGHT,
            ]}
            deviceType={deviceType}
            onChange={(option, checked): void => {
                const newValue = checked
                    ? [...values, option]
                    : values.filter(value => value !== option);

                setValues(newValue);
            }}
        />
    );
};

export const WithTitle: TStorybookFunctionComponent = () => {
    const [values, setValues] = useState<ETimeOfDay[]>([]);
    const deviceType = useDeviceType();

    return (
        <TimeFilter
            title="Отправление"
            value={values}
            availableValues={[
                ETimeOfDay.MORNING,
                ETimeOfDay.DAY,
                ETimeOfDay.NIGHT,
            ]}
            options={[
                ETimeOfDay.MORNING,
                ETimeOfDay.DAY,
                ETimeOfDay.EVENING,
                ETimeOfDay.NIGHT,
            ]}
            deviceType={deviceType}
            onChange={(option, checked): void => {
                const newValue = checked
                    ? [...values, option]
                    : values.filter(value => value !== option);

                setValues(newValue);
            }}
        />
    );
};
