import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {EToggleSize} from 'components/Toggle/types';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import cx from './Toggle.scss';

interface IToggleProps extends IWithClassName, IWithQaAttributes {
    isActive: boolean;
    size?: EToggleSize;
    isDisabled?: boolean;
    onToggle?(): void;
}

const Toggle: React.FC<IToggleProps> = props => {
    const {
        className,
        isActive,
        size = EToggleSize.S,
        isDisabled = false,
        onToggle,
    } = props;

    return (
        <div
            className={cx(
                'root',
                {
                    root_active: isActive,
                    root_disabled: isDisabled,
                },
                `root_size_${size}`,
                className,
            )}
            onClick={isDisabled ? undefined : onToggle}
            {...prepareQaAttributes(props)}
        >
            <div className={cx('circle')} />
        </div>
    );
};

export default React.memo(Toggle);
