import React, {ReactNode} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useMobile} from 'utilities/hooks/useMobile';
import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import {EMessageBoxPopupTheme} from 'components/MessageBoxPopup/MessageBoxPopup';
import TriggerDetailsButtonDesktop from './components/TriggerDetailsButtonDesktop/TriggerDetailsButtonDesktop';
import TriggerDetailsButtonMobile from './components/TriggerDetailsButtonMobile/TriggerDetailsButtonMobile';

export interface ITriggerDetailsButtonProps
    extends IWithClassName,
        IWithQaAttributes {
    iconClassName?: string;
    forceBottomSheet?: boolean;
    theme?: EMessageBoxPopupTheme;
    children: ReactNode;
}

const TriggerDetailsButton: React.FC<ITriggerDetailsButtonProps> = ({
    forceBottomSheet,
    theme = EMessageBoxPopupTheme.DEFAULT,
    ...props
}) => {
    const isMobile = useMobile();

    return forceBottomSheet ?? isMobile ? (
        <TriggerDetailsButtonMobile {...props} />
    ) : (
        <TriggerDetailsButtonDesktop {...props} theme={theme} />
    );
};

export default React.memo(TriggerDetailsButton);
