import {useState, useCallback} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Button from 'components/Button/Button';

import UpdateNotification from './UpdateNotification';

export default {
    title: 'Example/UpdateNotification',
    component: UpdateNotification,
} as Meta;

const TIMEOUT = 3000;

export const Simple: TStorybookFunctionComponent = () => {
    const [isStarted, setStarted] = useState(false);

    const handleCloseAction = useCallback(() => {
        setStarted(false);
    }, [setStarted]);

    return (
        <>
            <Button onClick={(): void => setStarted(true)} disabled={isStarted}>
                {isStarted ? `Погоди ${TIMEOUT / 1000} сек` : 'Поехали'}
            </Button>
            {isStarted && (
                <UpdateNotification
                    timeout={TIMEOUT}
                    onUpdate={handleCloseAction}
                    onSkip={handleCloseAction}
                />
            )}
        </>
    );
};

Simple.parameters = {
    info: {
        title: 'Уведомитель об устаревании данных на странице',
        comment: (
            <>
                Через заданное время показывает модальное окно с кнопкой для
                обновления
                <br />
                <br />
                Для тестирования (не в production окружении): можно в адресной
                строке указать query параметр `testOutdateTimeout` с указанием
                задержки появления окна в миллисекундах, пример:
                <br />
                `https://travel-test.yandex.ru/avia/search/result/?adult_seats=1&testOutdateTimeout=1000`
                <br />
                <br />
                Параметр isSkippable позволяет задавать, можно ли скрыть попап
                без целевого экшна, по умолчанию true
            </>
        ),
    },
};

export const NonSkippable: TStorybookFunctionComponent = () => {
    const [isStarted, setStarted] = useState(false);

    const handleCloseAction = useCallback(() => {
        setStarted(false);
    }, [setStarted]);

    return (
        <>
            <Button onClick={(): void => setStarted(true)} disabled={isStarted}>
                {isStarted ? `Погоди ${TIMEOUT / 1000} сек` : 'Поехали'}
            </Button>
            {isStarted && (
                <UpdateNotification
                    timeout={TIMEOUT}
                    onUpdate={handleCloseAction}
                    isSkippable={false}
                />
            )}
        </>
    );
};

NonSkippable.parameters = {
    info: {
        title: 'Уведомитель об устаревании данных на странице, нельзя скипнуть',
        comment: (
            <>
                Параметр isSkippable позволяет задавать, можно ли скрыть попап
                без целевого экшна, по умолчанию true, здесь false
            </>
        ),
    },
};
