import {useCallback, useEffect} from 'react';
import {parse} from 'query-string';

import appData from 'utilities/appData/appData';
import {useBoolean} from 'utilities/hooks/useBoolean';

interface IOptions {
    timeout: number;
    onShowNotification?(): void;
}

interface IUpdateNotification {
    isVisible: boolean;
    open(): void;
    close(): void;
}

export default function useUpdateNotification({
    timeout,
    onShowNotification,
}: IOptions): IUpdateNotification {
    const {
        setFalse: close,
        setTrue: open,
        value: isVisible,
    } = useBoolean(false);

    const openHandler = useCallback(() => {
        open();

        onShowNotification?.();
    }, [open, onShowNotification]);

    useEffect(() => {
        let ms;

        if (appData.isProductionEnv) {
            ms = timeout;
        } else {
            const {testOutdateTimeout} = parse(document.location.search);

            ms = Number(testOutdateTimeout) || timeout;
        }

        const timeoutId = setTimeout(openHandler, ms);

        return (): void => clearTimeout(timeoutId);
    }, [openHandler, timeout]);

    return {
        open,
        close,
        isVisible,
    };
}
