import React from 'react';

import * as i18nBlock from 'i18nNew/yandexUser';

import Link from 'components/Link/Link';
import Flex from 'components/Flex/Flex';

import cx from './Footer.scss';

const Footer: React.FC = () => {
    return (
        <Flex>
            <Link
                className={cx('settings')}
                theme="black"
                url="https://yandex.ru/tune"
            >
                {i18nBlock.settings()}
            </Link>

            <Link
                className={cx('help')}
                theme="black"
                url="https://yandex.ru/support/"
            >
                {i18nBlock.help()}
            </Link>
        </Flex>
    );
};

export default React.memo(Footer);
