import React, {useCallback} from 'react';

import {IAuthUserInfo} from 'reducers/common/commonReducerTypes';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

import Menu from 'components/User/components/Menu/Menu';
import Separator from 'components/Separator/Separator';
import Accounts from 'components/User/components/Accounts/Accounts';
import Footer from 'components/User/components/Footer/Footer';
import CloseIcon from 'icons/16/Close';

import cx from './PopupContent.scss';

interface IPopupContentProps {
    userInfo: IAuthUserInfo;
    unreadMailCount: number;
    returnPathUrl: string;
    hidePopup(): void;
}

const PopupContent: React.FC<IPopupContentProps> = props => {
    const {userInfo, unreadMailCount, returnPathUrl, hidePopup} = props;

    const deviceType = useDeviceType();

    const handleClose = useImmutableCallback(
        (e: React.MouseEvent<SVGElement>) => {
            e.stopPropagation();

            hidePopup();
        },
    );

    const handleClick = useCallback((e: React.MouseEvent<HTMLDivElement>) => {
        e.stopPropagation();
    }, []);

    return (
        <div onClick={handleClick}>
            <Menu
                userInfo={userInfo}
                unreadMailCount={unreadMailCount}
                returnPathUrl={returnPathUrl}
            />

            <Separator />

            <Accounts userInfo={userInfo} returnPathUrl={returnPathUrl} />

            <Footer />

            {deviceType.isMobile && (
                <CloseIcon className={cx('close')} onClick={handleClose} />
            )}
        </div>
    );
};

export default React.memo(PopupContent);
