import {useEffect, useMemo} from 'react';

import {YANDEX_ROOT_PATH} from 'constants/common';

import {useBoolean} from 'utilities/hooks/useBoolean';

/**
 * На сервере нет document.location и урл страницы можно узнать только через req,
 * но чтобы компонент узнал о нем, нужно прокинуть информацию через редакс,
 * что выглядит немного оверхедно.
 * Рендерить на сервере один урл, а на клиенте другой вне useEffect нельзя,
 * т.к. иначе будет несовпадение серверной и клиентской верстки.
 */
export default function useReturnPathUrl(): string {
    const {value: canRedirectToTravel, setTrue: setCanRedirect} =
        useBoolean(false);

    useEffect(setCanRedirect, []);

    return useMemo(() => {
        return canRedirectToTravel ? document.location.href : YANDEX_ROOT_PATH;
    }, [canRedirectToTravel]);
}
