import {useCallback, useState} from 'react';
import {IYMapsApi} from 'react-yandex-maps';

import {tupple} from 'utilities/tupple';

export function useYandexMapInstance() {
    const [yandexMapAPIInstance, setYandexMapAPIInstance] =
        useState<IYMapsApi | null>(null);

    const handleMapLoad = useCallback((yandexMapAPI: IYMapsApi) => {
        if (yandexMapAPI) {
            setYandexMapAPIInstance(yandexMapAPI);
        }
    }, []);

    return tupple(yandexMapAPIInstance, handleMapLoad);
}
