import {YaMapBoundsType, YaMapCoordinatesType} from 'react-yandex-maps';

import {
    ICoordinates,
    MapBoundsType,
    MapBoundsAsStringType,
} from 'types/common/ICoordinates';

/* Yandex Map component helpers */

export const convertCoordinates = (
    coordinates: YaMapCoordinatesType,
): ICoordinates => {
    const [lat, lon]: YaMapCoordinatesType = coordinates || [];

    return {lat, lon};
};

export const convertBounds = (bounds: YaMapBoundsType): MapBoundsType => {
    const [leftCorner, rightCorner]: YaMapBoundsType = bounds || [];

    return [convertCoordinates(leftCorner), convertCoordinates(rightCorner)];
};

/* Yandex Map API helpers */

export const convertCoordinatesToMapAPI = (
    coordinates: ICoordinates,
): YaMapCoordinatesType => {
    const {lat, lon}: ICoordinates = coordinates || {};

    return [lat, lon];
};

export const convertBoundsToMapAPI = (bounds: MapBoundsType) => {
    const [leftCorner, rightCorner]: MapBoundsType = bounds || [];

    return [
        convertCoordinatesToMapAPI(leftCorner),
        convertCoordinatesToMapAPI(rightCorner),
    ];
};

export const convertBoundsToString = (
    bounds: MapBoundsType,
): MapBoundsAsStringType =>
    bounds.map(({lon, lat}) => `${lon},${lat}`).join('~');

export const isDifferenceBounds = (
    prevBounds?: MapBoundsType,
    nextBounds?: MapBoundsType,
): boolean => {
    if (nextBounds && prevBounds && nextBounds !== prevBounds) {
        return (
            convertBoundsToString(prevBounds) !==
            convertBoundsToString(nextBounds)
        );
    }

    return false;
};
