import {FunctionComponent} from 'react';

import {TMetrikaGoal} from 'utilities/metrika/types/goals/all';

import {TEntryPoint} from 'components/YandexMessenger/utilities/prepareMetadata';

import Hanging from 'components/Hanging/Hanging';
import YandexMessenger from 'components/YandexMessenger/YandexMessenger';

import cx from './HangingYandexMessenger.scss';

interface IHangingYandexMessenger {
    entrypoint: TEntryPoint;
    metrikaGoal: TMetrikaGoal;
}

const HangingYandexMessenger: FunctionComponent<IHangingYandexMessenger> = ({
    entrypoint,
    metrikaGoal,
}) => {
    return (
        <Hanging>
            <YandexMessenger
                className={cx('messenger')}
                entrypoint={entrypoint}
                metrikaGoal={metrikaGoal}
            />
        </Hanging>
    );
};

export default HangingYandexMessenger;
