import React from 'react';

import YandexMaps, {IYandexMapsProps} from 'components/YandexMaps/YandexMaps';

import cx from './YandexReadonlyMaps.scss';

interface IYandexReadonlyMapsProps
    extends Omit<
        IYandexMapsProps,
        'hasZoomControl' | 'hasGeoLocationControl' | 'controls'
    > {
    rootClassName?: string;
    hideCopyright?: boolean;

    onClick?(): void;
}

const CONTROLS: string[] = [];

const YandexReadonlyMaps: React.FC<IYandexReadonlyMapsProps> = props => {
    const {className, rootClassName, hideCopyright, onClick, ...rest} = props;

    return (
        <div className={cx('root', rootClassName)} onClick={onClick}>
            <YandexMaps
                className={cx('map', className, {
                    map_hideCopyright: hideCopyright,
                })}
                hasZoomControl={false}
                hasGeoLocationControl={false}
                controls={CONTROLS}
                {...rest}
            />

            <div className={cx('readonlyOverlay')} />
        </div>
    );
};

export default YandexReadonlyMaps;
