import React from 'react';
import {withRouter, RouteComponentProps} from 'react-router-dom';

import {commonBrowserProvider as commonService} from 'serviceProvider/common/commonBrowserProvider';

export interface IUpdateLink {
    tinyUrl: string;
}

export const withUpdateTinyUrl = <P extends IUpdateLink>(
    LinkComponent: React.ComponentType<P>,
) => {
    class LinkUpdateComponent extends React.Component<
        RouteComponentProps & Omit<P, keyof IUpdateLink>,
        IUpdateLink
    > {
        readonly state: IUpdateLink = {
            tinyUrl: '',
        };

        componentDidMount(): void {
            this.updateTinyUrl();
        }

        componentDidUpdate(prevProps: RouteComponentProps): void {
            if (
                this.props.location.search !== prevProps.location.search ||
                this.props.location.hash !== prevProps.location.hash
            ) {
                this.updateTinyUrl();
            }
        }

        private updateTinyUrl() {
            commonService
                .store({
                    url: window.location.href,
                })
                .then(tinyUrl => {
                    this.setState({tinyUrl});
                })
                .catch(() => {
                    this.setState({tinyUrl: ''});
                });
        }

        render() {
            return (
                <LinkComponent
                    {...(this.props as any)}
                    tinyUrl={this.state.tinyUrl}
                />
            );
        }
    }

    return withRouter(LinkUpdateComponent);
};
