import {EAffiliateField} from 'types/affiliate/EAffiliateField';

export enum EAffiliateQueryParams {
    /** @depricated */
    CLID = 'clid',
    /** @depricated */
    VID = 'vid',
    AFFILIATE_CLID = 'affiliate_clid',
    ADMITAD_UID = 'admitad_uid',
    TRAVEL_PAYOUTS_UID = 'travelpayouts_uid',
    AFFILIATE_VID = 'affiliate_vid',
}

export const PARTNERS_QUERY_PARAMS = Object.values(EAffiliateQueryParams);

export const affiliateQueryParamsMap: Record<
    EAffiliateField,
    EAffiliateQueryParams
> = {
    [EAffiliateField.CLID]: EAffiliateQueryParams.CLID,
    [EAffiliateField.VID]: EAffiliateQueryParams.VID,
    [EAffiliateField.AFFILIATE_CLID]: EAffiliateQueryParams.AFFILIATE_CLID,
    [EAffiliateField.AFFILIATE_VID]: EAffiliateQueryParams.AFFILIATE_VID,
    [EAffiliateField.ADMITAD_UID]: EAffiliateQueryParams.ADMITAD_UID,
    [EAffiliateField.TRAVEL_PAYOUTS_UID]:
        EAffiliateQueryParams.TRAVEL_PAYOUTS_UID,
};
