import {RUS, ENG, DIGITS} from './masks';

export const WHITE_SPACE = ' ';

export const FREE_PHONE_REGEXP = `^([^${DIGITS}]*[${DIGITS}]){10,}[^${DIGITS}]*$`;

export function getPhoneValidationRegExp(
    minNumbers: number = 10,
    maxNumbers?: number,
): string {
    return `^([^0-9]*[0-9]){${minNumbers},${maxNumbers || ''}}[^0-9]*$`;
}

const VALID_EMAIL_SPECIAL_CHARACTERS = "_#$%&'*+/=!?^.`{}|~-";

interface IGetEmailValidationRegExp {
    allowRussianCharacters?: boolean;
}

export function getEmailValidationRegExp({
    allowRussianCharacters = false,
}: IGetEmailValidationRegExp = {}): string {
    const LETTERS = allowRussianCharacters ? `${ENG}${RUS}` : ENG;

    const LEFT_PART = `${LETTERS}${DIGITS}${VALID_EMAIL_SPECIAL_CHARACTERS}`;
    const LEFT_PART_WITHOUT_DOT = LEFT_PART.replace(/\./g, '');

    const RIGHT_PART = `${LETTERS}${DIGITS}-.`;

    return `^${WHITE_SPACE}*[${LEFT_PART_WITHOUT_DOT}]+[${LEFT_PART}]*@[${RIGHT_PART}]+\\.[${LETTERS}]{2,}${WHITE_SPACE}*$`;
}
