import {WEB, IOS, ANDROID, WP} from 'server/constants/platforms';

export type TPlatform = typeof WEB | typeof IOS | typeof ANDROID | typeof WP;

export enum EAppActions {
    ADD_TO_FAVORITES = 'addToFavorites',
    REMOVE_FROM_FAVORITES = 'removeFromFavorites',
    SHARE = 'share', // не используется, контрол отсутствует
    SHOW_SEARCH_FORM = 'showSearchForm',
    BUY_TICKETS = 'buyTickets',
    OPEN_HISTORY = 'openHistory',
    OPEN_MENU = 'openMenu',
    REACH_METRIKA_GOAL = 'reachMetrikaGoal', // для андроида нужно объеденить с вызовами метрики

    /**
     * Переход на главную портала
     */
    NAVIGATE_TO_INDEX_PAGE = 'navigateToIndexPage',

    /**
     * Переход на поиск отелей
     */
    NAVIGATE_TO_SEARCH_HOTELS_PAGE = 'navigateToSearchHotelsPage',

    /**
     * Переход на страницу поездок
     */
    NAVIGATE_TO_TRIPS_PAGE = 'navigateToTripsPage',
}
