import React from 'react';
import {useSelector} from 'react-redux';

import {METRIKA_SCRIPT} from 'constants/urls/externals';

import isBotSelector from 'selectors/common/isBot';

import DynamicScript from 'components/DynamicScript/DynamicScript';

const MetrikaScript: React.FC = () => {
    const isBot = useSelector(isBotSelector);

    if (isBot) {
        return null;
    }

    return <DynamicScript src={METRIKA_SCRIPT} />;
};

export default React.memo(MetrikaScript);
