import {LoadableComponent} from '@loadable/component';

import {EProjectName} from 'constants/common';

import {loadable} from 'utilities/pageLoadable';

const HotelsApp = loadable(
    () => import('projects/depreacted/hotels/applications/HotelsApp/HotelsApp'),
);

const LegacyHotelApp = loadable(
    () => import('projects/depreacted/hotels/applications/LegacyHotelApp/LegacyHotelApp'),
);

const NotFoundApp = loadable(
    () => import('components/NotFound/NotFoundPage/NotFoundPage'),
);

export default (projectType: EProjectName): LoadableComponent<any> => {
    switch (projectType) {
        case EProjectName.HOTELS:
            return HotelsApp;
        case EProjectName.HOTEL:
            return LegacyHotelApp;
        case EProjectName.NOT_FOUND:
            return NotFoundApp;
    }
};
