import {logWarning} from 'utilities/logger/logWarning';

export default function checkCssVariablesSupport(): void {
    if (typeof window === 'undefined') {
        return;
    }

    if (!window.CSS?.supports('color', 'var(--fake-var)')) {
        logWarning({
            message: '[YATRAVEL][COMMON] Нет поддержки CSS-переменных',
        });
    }
}
