import {ServerDataFetcherBag} from 'server/redux/types';

import {fetchUserPlusInfo} from 'reducers/common/userInfo/thunk';
import {fetchIsSubscribed} from 'reducers/common/subscription/status/thunk';

export async function prefetchData({
    req,
    dispatch,
}: ServerDataFetcherBag): Promise<void> {
    await Promise.all([
        dispatch(fetchUserPlusInfo(req)),
        dispatch(fetchIsSubscribed(req)),
    ]);
}
