import React, {useCallback, useState} from 'react';
import {isString} from 'lodash';

import {URLs} from 'constants/urls';

import {deviceModMobile} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {useQueryByLocation} from 'utilities/hooks/useQueryByLocation';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import {successLinkText, successTextWithLink} from 'i18nNew/common-auth';

import Link from 'components/Link/Link';
import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import NotFoundPage from 'components/NotFound/NotFoundPage/NotFoundPage';
import LayoutDefault from 'components/Layouts/LayoutDefault/LayoutDefault';
import CheckOrderAuthorization from 'components/CheckOrderAuthorization/CheckOrderAuthorizationContainer';

import cx from './AuthTicket.scss';

const AuthTicket: React.FC = () => {
    const deviceType = useDeviceType();
    const {retpath, orderId} = useQueryByLocation();
    const downloadLink = isString(retpath) ? retpath : URLs.account;
    const [isAuthorized, setIsAuthorized] = useState(false);

    const onSuccess = useCallback(() => {
        window.location.href = downloadLink;
        setIsAuthorized(true);
    }, [downloadLink]);

    if (!orderId) {
        return <NotFoundPage />;
    }

    return (
        <LayoutDefault>
            {isAuthorized ? (
                <Flex
                    className={cx('success')}
                    alignItems="center"
                    justifyContent="center"
                    x="8"
                >
                    <Text>
                        {insertJSXIntoKey(successTextWithLink)({
                            link: (
                                <Link url={downloadLink}>
                                    {successLinkText()}
                                </Link>
                            ),
                        })}
                    </Text>
                </Flex>
            ) : (
                <CheckOrderAuthorization
                    className={cx('root', deviceModMobile('root', deviceType))}
                    orderId={orderId as string}
                    onSuccessOrderAuthorization={onSuccess}
                />
            )}
        </LayoutDefault>
    );
};

export default AuthTicket;
