import React, {useEffect} from 'react';

import {ECommonGoal} from 'utilities/metrika/types/goals/common';
import {IInlineSubscriptionContainerProps} from 'containers/Subscriptions/types';

import {reachGoal} from 'utilities/metrika';
import {useUserInfo} from 'utilities/hooks/useUserInfo';
import {isAuthUser} from 'utilities/userInfo/isAuthUser';
import {useExperiments} from 'utilities/hooks/useExperiments';
import {useSubscriptionHandlers} from 'containers/Subscriptions/utilities/useSubscriptionHandlers';
import {useSubscriptionMetrikaParams} from 'containers/Subscriptions/utilities/useSubscriptionMetrikaParams';

import SubscriptionWithPromoCode from 'containers/Subscriptions/Inline/SubscriptionWithPromoCode';

import SubscriptionInline from 'components/SubscriptionInline/SubscriptionInline';

const InlineSubscription: React.FC<
    Omit<IInlineSubscriptionContainerProps, 'onSubmit' | 'email'>
> = props => {
    const {
        vertical,
        source,
        promoSubscriptionCode = 'ESubscriptionCode.travelNews',
    } = props;
    const userInfo = useUserInfo();
    const {subscriptionWithPromoCode} = useExperiments();
    const {handleSubmit, handleTrySubmit} = useSubscriptionHandlers(
        vertical,
        source,
        promoSubscriptionCode,
    );
    const metrikaParams = useSubscriptionMetrikaParams(vertical, source);

    useEffect(() => {
        reachGoal(ECommonGoal.SUBSCRIPTION_BLOCK_SHOWN, metrikaParams);
    }, [metrikaParams]);

    const SubscriptionComponent = subscriptionWithPromoCode
        ? SubscriptionWithPromoCode
        : SubscriptionInline;

    return (
        <SubscriptionComponent
            {...props}
            email={isAuthUser(userInfo) ? userInfo.contacts.email : undefined}
            onSubmit={handleSubmit}
            onBeforeSubmit={handleTrySubmit}
        />
    );
};

export default InlineSubscription;
