import React from 'react';

import {IInlineSubscriptionContainerProps} from 'containers/Subscriptions/types';

import {useIsUserSubscribed} from 'utilities/hooks/subscription/useIsUserSubscribed';
import {useShouldShowSubscription} from 'utilities/hooks/useShouldShowSubscription';

import InlineSubscription from 'containers/Subscriptions/Inline/InlineSubscription';

const OptionalSubscription: React.FC<
    Omit<IInlineSubscriptionContainerProps, 'onSubmit'>
> = props => {
    const isUserSubscribed = useIsUserSubscribed();
    const canShowSubscription = useShouldShowSubscription();

    if (!canShowSubscription || isUserSubscribed) {
        return null;
    }

    return <InlineSubscription {...props} />;
};

export default OptionalSubscription;
