import React from 'react';

import {IInlineSubscriptionContainerProps} from 'containers/Subscriptions/types';

import {useAsyncSubscriptionConfig} from 'utilities/hooks/subscription/useFetchSubscriptionConfig';

import SubscriptionInline from 'components/SubscriptionInline/SubscriptionInline';
import SubscriptionSkeleton from 'components/SubscriptionSkeleton/SubscriptionSkeleton';

const SubscriptionWithPromoCode: React.FC<IInlineSubscriptionContainerProps> =
    ({vertical, ...props}) => {
        const state = useAsyncSubscriptionConfig(vertical);

        return state.loading ? (
            <SubscriptionSkeleton
                {...props}
                withPromoCode={Boolean(state.data)}
            />
        ) : (
            <SubscriptionInline
                {...props}
                promoCode={state.data ?? undefined}
            />
        );
    };

export default SubscriptionWithPromoCode;
