import React from 'react';

import {ESubscriptionCode} from 'types/subscription/ESubscriptionCode';
import {IPopupSubscriptionContainerProps} from 'containers/Subscriptions/types';

import {useUserInfo} from 'utilities/hooks/useUserInfo';
import {isAuthUser} from 'utilities/userInfo/isAuthUser';
import {useExperiments} from 'utilities/hooks/useExperiments';
import {useShouldShowSubscription} from 'utilities/hooks/useShouldShowSubscription';
import {useIsUserSubscribed} from 'utilities/hooks/subscription/useIsUserSubscribed';
import {useSubscriptionHandlers} from 'containers/Subscriptions/utilities/useSubscriptionHandlers';

import PopupSubscriptionController from 'containers/Subscriptions/Popup/PopupSubscriptionController';
import PopupSubscriptionWithPromoCode from 'containers/Subscriptions/Popup/PopupSubscriptionWithPromocode';

const PopupSubscription: React.FC<
    Omit<IPopupSubscriptionContainerProps, 'onSubmit'>
> = props => {
    const {
        vertical,
        source,
        promoSubscriptionCode = ESubscriptionCode.travelNews,
    } = props;
    const userInfo = useUserInfo();
    const experiments = useExperiments();
    const {handleSubmit, handleTrySubmit} = useSubscriptionHandlers(
        vertical,
        source,
        promoSubscriptionCode,
    );

    const isUserSubscribed = useIsUserSubscribed();
    const canShowSubscription = useShouldShowSubscription();

    if (!canShowSubscription || isUserSubscribed) {
        return null;
    }

    const SubscriptionComponent = experiments.subscriptionWithPromoCode
        ? PopupSubscriptionWithPromoCode
        : PopupSubscriptionController;

    return (
        <SubscriptionComponent
            {...props}
            email={isAuthUser(userInfo) ? userInfo.contacts.email : undefined}
            onSubmit={handleSubmit}
            onBeforeSubmit={handleTrySubmit}
        />
    );
};

export default PopupSubscription;
