import React from 'react';

import {IPopupSubscriptionContainerProps} from 'containers/Subscriptions/types';

import {useAsyncSubscriptionConfig} from 'utilities/hooks/subscription/useFetchSubscriptionConfig';

import PopupSubscriptionController from 'containers/Subscriptions/Popup/PopupSubscriptionController';

const PopupSubscriptionWithPromoCode: React.FC<IPopupSubscriptionContainerProps> =
    props => {
        const state = useAsyncSubscriptionConfig(props.vertical);

        return state.loading ? null : (
            <PopupSubscriptionController
                {...props}
                promoCode={state.data ?? undefined}
            />
        );
    };

export default PopupSubscriptionWithPromoCode;
