import {useMemo} from 'react';

import {ESubscriptionVerticalName} from 'types/subscription/ESubscriptionVerticalName';
import {ESubscriptionSource} from 'types/subscription/ESubscriptionSource';
import {IMetrikaCommonSubscriptionsParams} from 'utilities/metrika/types/params/common';

export function useSubscriptionMetrikaParams(
    vertical: ESubscriptionVerticalName,
    source: ESubscriptionSource,
): IMetrikaCommonSubscriptionsParams {
    return useMemo(
        () => ({
            common: {
                subscriptions: {
                    source,
                    vertical,
                },
            },
        }),
        [source, vertical],
    );
}
