import React from 'react';
import {withRouter, RouteComponentProps} from 'react-router-dom';

import {IBrowserHistoryState} from 'utilities/browserHistory/browserHistory';
import useSupportHistoryBack from 'utilities/hooks/useSupportHistoryBack';

import Modal, {IModalProps} from 'components/Modal/Modal';

export interface IModalWithHistoryBackProps
    extends IModalProps,
        RouteComponentProps<any, any, IBrowserHistoryState> {
    onHistoryBack?(): void;
}

const ModalWithHistoryBack: React.FC<IModalWithHistoryBackProps> = props => {
    const {children, onHistoryBack, ...restProps} = props;

    useSupportHistoryBack({
        isVisible: props.isVisible,
        onHistoryBack,
        close: props.onClose,
    });

    return <Modal {...restProps}>{children}</Modal>;
};

export default withRouter(ModalWithHistoryBack);
