import React from 'react';

import {useWindowLayout} from 'utilities/hooks/useWindowLayout';

export interface IWithWindowSize {
    windowWidth: number;
    windowHeight: number;
}

type TWithoutWindowSize<P> = Omit<P, keyof IWithWindowSize>;

export function withWindowSize(
    throttleMs?: number,
): <P extends IWithWindowSize>(
    Component: React.ComponentType<P>,
) => React.ComponentType<TWithoutWindowSize<P>> {
    return <P extends IWithWindowSize>(
        Component: React.ComponentType<P>,
    ): React.ComponentType<TWithoutWindowSize<P>> => {
        const WithWindowSize: React.FC<TWithoutWindowSize<P>> = props => {
            const {width, height} = useWindowLayout(throttleMs);

            return (
                // @ts-ignore
                <Component
                    windowWidth={width}
                    windowHeight={height}
                    {...props}
                />
            );
        };

        WithWindowSize.displayName = `withWindowSize(${
            Component.displayName || Component.name
        })`;

        return WithWindowSize;
    };
}
