import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AeroexpressIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5.47665 0.722562C5.47665 0.433961 5.709 0.199997 6.00011 0.199997C6.28921 0.199997 6.52357 0.433798 6.52357 0.722562V1.24771L8.09394 2.81927L7.57048 3.34312L6.52357 2.81927V4.91468H5.47665V2.81927L4.42974 3.34312L3.90628 2.81927L5.47665 1.24771V0.722562ZM0.85998 5.36566L0.360916 5.20339C0.0866427 5.1142 -0.0639012 4.82076 0.0260577 4.54369C0.115394 4.26853 0.410006 4.11772 0.684431 4.20696L1.18349 4.36924L3.16228 3.36023L3.49836 4.02032L2.677 4.85487L4.66835 5.50239L4.34484 6.49882L2.35349 5.8513L2.52781 7.00961L1.86822 7.34595L0.859976 5.36566L0.85998 5.36566ZM3.03835 11.4571C2.86884 11.6906 2.54346 11.7432 2.30794 11.5719C2.07406 11.4019 2.02178 11.0749 2.19138 10.8413L2.49982 10.4164L2.1524 8.22124L2.88357 8.10535L3.42286 9.14498L4.65358 7.44976L5.50056 8.06558L4.26983 9.76081L5.42449 9.95283L5.54029 10.6846L3.34679 11.0322L3.03835 11.4571ZM9.5004 10.4164L9.80884 10.8413C9.97835 11.0747 9.92779 11.4007 9.69228 11.5719C9.45839 11.742 9.13147 11.6907 8.96187 11.4571L8.65343 11.0322L6.45993 10.6846L6.57574 9.95283L7.73039 9.76081L6.49967 8.06558L7.34664 7.44976L8.57736 9.14498L9.11665 8.10535L9.84782 8.22124L9.5004 10.4164L9.5004 10.4164ZM10.8167 4.36923L11.3158 4.20696C11.5901 4.11777 11.8842 4.26661 11.9742 4.54369C12.0635 4.81885 11.9137 5.11415 11.6393 5.20339L11.1402 5.36566L10.132 7.34595L9.47241 7.00961L9.64673 5.8513L7.65538 6.49882L7.33187 5.50239L9.32322 4.85487L8.50187 4.02032L8.83795 3.36023L10.8167 4.36923L10.8167 4.36923Z"
            fill={props.fill}
        />
    </svg>
);

AeroexpressIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default AeroexpressIcon;
