import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowLongRightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.7878 3.40605C6.60016 3.21841 6.49475 2.96392 6.49475 2.69855C6.49475 2.43319 6.60016 2.17869 6.7878 1.99105C6.97544 1.80341 7.22994 1.698 7.4953 1.698C7.76067 1.698 8.01516 1.80341 8.2028 1.99105L11.5028 5.29206C11.6903 5.47958 11.7956 5.73389 11.7956 5.99906C11.7956 6.26422 11.6903 6.51853 11.5028 6.70606L8.2028 10.0051C8.01516 10.1926 7.76072 10.2979 7.49545 10.2978C7.23018 10.2977 6.97581 10.1922 6.7883 10.0046C6.60079 9.81692 6.49551 9.56247 6.4956 9.2972C6.49569 9.03193 6.60116 8.77757 6.7888 8.59006L6.7028 8.67705C7.23468 8.14579 7.82473 7.67616 8.4618 7.27706L9.2088 6.80706L9.1618 6.76106L8.2028 6.89806C7.73443 6.9648 7.26191 6.99821 6.7888 6.99806H1C0.734784 6.99806 0.48043 6.8927 0.292893 6.70516C0.105357 6.51763 0 6.26327 0 5.99806C0 5.73284 0.105357 5.47849 0.292893 5.29095C0.48043 5.10341 0.734784 4.99806 1 4.99806H6.7898C7.26293 4.99823 7.73545 5.03198 8.2038 5.09906L9.1638 5.23606L9.2098 5.18906L8.4598 4.71906C7.82378 4.32015 7.23474 3.85086 6.7038 3.32006L6.7878 3.40605Z"
            fill={props.fill}
        />
    </svg>
);

ArrowLongRightIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default ArrowLongRightIcon;
