import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowRightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3 1.25L7.6 6L3 10.75L3.72 11.5L9 6L3.72 0.5L3 1.25Z"
            fill={props.fill}
        />
    </svg>
);

ArrowRightIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default ArrowRightIcon;
