import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowTopIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.75 9L6 4.4L1.25 9L0.5 8.28L6 3L11.5 8.28L10.75 9Z"
            fill={props.fill}
        />
    </svg>
);

ArrowTopIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default ArrowTopIcon;
