import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BoatIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#abd9a8c5__clip0_11628_3)">
            <path
                d="M6.82943 0.248399L7.12193 2.19999H4.86377L5.15627 0.248399C5.17767 0.105624 5.30022 0 5.44447 0H6.54122C6.68548 0 6.80803 0.105624 6.82943 0.248399Z"
                fill={props.fill}
            />
            <path
                d="M9.36016 2.99998C9.49491 2.99998 9.61209 3.09244 9.64354 3.22358L10.3893 5.99997L6.58139 4.59998C6.20155 4.43714 5.77139 4.43479 5.39257 4.59998L1.59643 5.99997L2.34216 3.22358C2.3736 3.09244 2.49079 2.99998 2.62554 2.99998H9.36016Z"
                fill={props.fill}
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M0.300126 7.78104C0.286089 7.78716 0.27234 7.79393 0.258923 7.80131C0.0171593 7.93439 -0.0710353 8.23842 0.0619346 8.48038L1.3718 10.8639C1.63419 11.3413 2.23024 11.5206 2.71217 11.2671C3.05068 11.089 3.47812 11 3.99454 11C4.74393 11 5.36842 11.25 5.99291 11.5C6.6174 11.75 7.24189 12 7.99128 12C8.97102 12 9.58998 11.641 9.98966 11C10.0064 10.9731 11.8967 8.51055 11.8967 8.51055C11.922 8.47752 11.9431 8.44146 11.9595 8.40321C12.0681 8.14937 11.9506 7.85546 11.6969 7.74673L6.18803 5.38509C6.06141 5.33081 5.91803 5.33126 5.79175 5.38632L0.300126 7.78104ZM7.49169 8.70002C7.87797 8.70002 8.19112 8.38662 8.19112 8.00002C8.19112 7.61342 7.87797 7.30003 7.49169 7.30003C7.1054 7.30003 6.79226 7.61342 6.79226 8.00002C6.79226 8.38662 7.1054 8.70002 7.49169 8.70002ZM5.19356 8.00002C5.19356 8.38662 4.88042 8.70002 4.49413 8.70002C4.10785 8.70002 3.7947 8.38662 3.7947 8.00002C3.7947 7.61342 4.10785 7.30003 4.49413 7.30003C4.88042 7.30003 5.19356 7.61342 5.19356 8.00002Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="abd9a8c5__clip0_11628_3">
                <rect width={12} height={12.0001} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

BoatIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default BoatIcon;
