import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DownChartsIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <circle cx={6} cy={6} r={6} fill={props.fill} />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.69856 5.4093L6.68165 4.31264C6.80124 4.24759 6.93868 4.23322 7.0674 4.26856C7.1968 4.3041 7.30967 4.38636 7.37831 4.5065L7.38439 4.51714L8.38781 6.91222L8.681 5.84454C8.75639 5.57001 9.04187 5.41938 9.30933 5.49283C9.57765 5.56651 9.74454 5.8444 9.66993 6.1161L9.02433 8.46716C8.94862 8.74285 8.66304 8.89092 8.39574 8.82092L8.39345 8.82032L5.98061 8.15773C5.71229 8.08405 5.5454 7.80616 5.62001 7.53446C5.69539 7.25993 5.98088 7.10931 6.24834 7.18276L7.53463 7.53597L6.71522 5.45487L4.73791 6.54833C4.61831 6.61338 4.48087 6.62776 4.35215 6.59241C4.22077 6.55633 4.11226 6.47393 4.04301 6.3575L4.03689 6.34721L2.82594 3.61379C2.78034 3.52929 2.7423 3.39833 2.78696 3.2357C2.82218 3.10744 2.9021 2.99915 3.02391 2.93295M4.69856 5.4093L3.72558 3.13516L3.7188 3.12377C3.64955 3.00735 3.54105 2.92494 3.40966 2.88887C3.28098 2.85353 3.14348 2.86795 3.02391 2.93295"
            fill="white"
        />
    </svg>
);

DownChartsIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default DownChartsIcon;
