import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FlightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#726e8e13__clip0_757_7)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M3.14507 7.50165C3.62515 6.90458 4.24365 6.16777 4.97645 5.36361L0.182066 2.16735C-0.0057728 2.04213 -0.0565305 1.78834 0.0686951 1.6005L0.679886 0.683713C0.787109 0.522879 0.992335 0.459138 1.17181 0.530927L7.31454 2.98802C10.5033 0.00104473 11.6005 -0.197895 11.9 0.10165C12.2 0.40165 12 1.50165 9 4.70165C7.82576 5.95417 5.85988 7.64407 4.5 8.77573V11.4154C4.5 11.532 4.43413 11.6386 4.32985 11.6907L3.7732 11.9691C3.62115 12.0451 3.43626 11.9835 3.36024 11.8314C3.35642 11.8238 3.35293 11.816 3.34976 11.8081L2.44799 9.55366L0.193569 8.65189C0.0357332 8.58876 -0.0410374 8.40963 0.0220969 8.25179C0.0252654 8.24387 0.0287619 8.23608 0.0325774 8.22845L0.310904 7.6718C0.363044 7.56752 0.469624 7.50165 0.586211 7.50165H3.14507ZM9.38141 5.60655L11.4707 10.8298C11.5425 11.0093 11.4788 11.2145 11.3179 11.3218L10.4012 11.933C10.2133 12.0582 9.95952 12.0074 9.8343 11.8196L7.07892 7.68652C7.71975 7.19394 8.37087 6.63078 9 6.00165C9.13253 5.86912 9.2596 5.73736 9.38141 5.60655Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="726e8e13__clip0_757_7">
                <rect width={12} height={12} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

FlightIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default FlightIcon;
