import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GiftIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 12 12"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.04 3H9.82165C10.2635 2.32921 10.3666 1.52331 10.0192 0.885678C9.49823 -0.070389 7.85486 -0.286093 6.72701 0.403888C6.44092 0.578906 6.20211 0.802828 6.0135 1.05519C5.82489 0.802828 5.58609 0.578906 5.3 0.403888C4.17215 -0.286093 2.52878 -0.070389 2.00785 0.885678C1.66043 1.52331 1.76355 2.32921 2.20536 3H0.96C0.623969 3 0.455953 3 0.327606 3.0654C0.214708 3.12292 0.12292 3.21471 0.0653961 3.32761C0 3.45595 0 3.62397 0 3.96V5.04C0 5.37603 0 5.54405 0.0653961 5.67239C0.12292 5.78529 0.214708 5.87708 0.327606 5.9346C0.455953 6 0.623968 6 0.96 6H11.04C11.376 6 11.544 6 11.6724 5.9346C11.7853 5.87708 11.8771 5.78529 11.9346 5.67239C12 5.54405 12 5.37603 12 5.04V3.96C12 3.62397 12 3.45595 11.9346 3.32761C11.8771 3.21471 11.7853 3.12292 11.6724 3.0654C11.544 3 11.376 3 11.04 3ZM8.13745 2.58656C8.62932 2.28565 8.80868 1.79918 8.70199 1.60336C8.64084 1.49113 7.9774 1.39737 7.50979 1.68344C7.07589 1.94888 6.90101 2.51958 7.04417 2.78232C7.07763 2.84371 7.62851 2.89791 8.13745 2.58656ZM3.32502 1.60336C3.38617 1.49113 4.04961 1.39737 4.51721 1.68344C4.95112 1.94888 5.12599 2.51958 4.98283 2.78232C4.94938 2.84371 4.39849 2.89791 3.88956 2.58656C3.39769 2.28565 3.21832 1.79918 3.32502 1.60336Z"
            fill={props.fill}
        />
        <path
            d="M1 7H5V9.74111C5 9.82684 5 9.8697 5.01805 9.89551C5.03382 9.91805 5.05817 9.9331 5.08538 9.93712C5.11655 9.94173 5.15488 9.92256 5.23155 9.88422L6.82311 9.08845C6.88731 9.05635 6.91943 9.04029 6.94288 9.01634C6.96363 8.99516 6.9794 8.96963 6.98907 8.94161C7 8.90992 7 8.87402 7 8.80223V7H11V11C11 11.5523 10.5523 12 10 12H2C1.44772 12 1 11.5523 1 11V7Z"
            fill={props.fill}
        />
    </svg>
);

GiftIcon.defaultProps = {
    width: 12,
    height: 12,
    fill: 'currentColor',
};

export default GiftIcon;
